<?php

if (!isset($_SESSION)) {
	session_start();
}
if (!isset($_SESSION['jetGoogleAuth_GoogleUserEmail'])) {
	$_SESSION['jetGoogleAuth_GoogleUserEmail'] = false;
}
if(!isset($_SESSION['jetGoogleAuth_USER_ID'])) {
	$_SESSION['jetGoogleAuth_USER_ID'] = 0;
}

include("config.php");

class jetGoogleAuth {

	public static function requireLogin($options) {
		if (!$_SESSION['jetGoogleAuth_GoogleUserEmail']) {
			if (isset($options->redirect)) {
				header("Location:".$options->redirect);
				return false;
			}
			if (isset($options->fun)) {
				$fun = $options->fun;
				$fun();
				return false;
			}
			return false;
		}
		return true;
	}

	public static function loginGoogleUser($email) {
		$query = "SELECT * FROM jetGoogleAuth_Users WHERE (email = '$email')";
		$q = jetGoogleAuth::dbQuery($query);
		if ($q['numrows']==1) {
			$_SESSION['jetGoogleAuth_USER_ID'] = $q['results'][0]['id'];
		} else {
			$query = "INSERT INTO jetGoogleAuth_Users (email) VALUES ('$email')";
			$q = jetGoogleAuth::dbQuery($query);
			$_SESSION['jetGoogleAuth_USER_ID'] = $q['id'];
		}
		return $_SESSION['jetGoogleAuth_USER_ID'];
	}

	public static function display($options) {
		global $jetGoogleAuth_WebPath, $google_client_id, $jetGoogleAuth_RelPath;
		$html = file_get_contents($jetGoogleAuth_RelPath."/login.html");
		$redirection = "";
		if (isset($options->redirect)) {
			$redirection = "if (refreshAfterLogin) { window.location.replace('".$options->redirect."'); }";
		}
		$html = str_replace("\$jetGoogleAuth_LoginRedirect", $redirection, $html);
		$html = str_replace("\$jetGoogleAuth_WebPath", $jetGoogleAuth_WebPath, $html);
		$html = str_replace("\$google_client_id", $google_client_id, $html);
		print $html;
	}
	
	public static function verify($id_token=false) {
		if (!$id_token) {
			$id_token = $_POST['idtoken'];
		}
		$client = new Google_Client(['client_id' => $google_client_id]);  // Specify the CLIENT_ID of the app that accesses the backend
		$payload = $client->verifyIdToken($id_token);
		$data = new stdClass();
		if ($payload) {
			if (isset($payload['email'])) {
				$data->email = $payload['email'];
				$_SESSION['jetGoogleAuth_GoogleUserEmail'] = $payload['email'];
				$query = "REPLACE INTO google_users (google_email) VALUES ('".$payload['email']."');";
			} else {
				$data->error = "Login failed.";
				$_SESSION['jetGoogleAuth_GoogleUserEmail'] = false;		
			}
		} else {
			$data->error = "User not found.";
		}
		return $data;
	}
	
	public static function logout() {
		$_SESSION['jetGoogleAuth_GoogleUserEmail'] = false;		
		$_SESSION['jetGoogleAuth_RefreshOnLogin'] = true;
		$data = new stdClass();
		$data->message = "Logged out!";
		print json_encode($data);
        
	}

	public static function dbQuery($query)
	{
		global $jetGoogleAuth_DatabaseCredentials;
		$cr = $jetGoogleAuth_DatabaseCredentials;

		$dbHost = $cr->Host;
	//	$dbPort = $cr->Port;
		$dbDatabase = $cr->Database;
		$dbUsername = $cr->Username;
		$dbPassword = $cr->Password;
		$dsn = 'mysql:dbname='.$dbDatabase.';host='.$dbHost; //.';port='.$dbPort;
		$db = new PDO($dsn, $dbUsername, $dbPassword);
		$query = trim($query);
		$q = array("numrows"=>0, "results"=>array(), "id"=>0);
		if (strtolower(substr($query,0,6))=="select") {
			$s = $db->query($query);
			if (!empty($s)) {
				$q['numrows'] = $s->rowCount();
				$q['results'] = $s->fetchAll(PDO::FETCH_ASSOC);
			} else {
	//			print "\n\nEMPTY\n\n";
			}
		}
		else if (strtolower(substr($query,0,6))=="insert") {
			$s = $db->prepare($query);
			$s->execute();
	//		$q['numrows'] = $s->rowCount();
			$q['id'] = $db->lastInsertId();
		}
		else if (strtolower(substr($query,0,7))=="replace") {
			$s = $db->prepare($query);
			$s->execute();
	//		$q['numrows'] = $s->rowCount();
			$q['id'] = $db->lastInsertId();
		}
		else if (strtolower(substr($query,0,6))=="update") {
			$s = $db->prepare($query);
			$s->execute();
			$q['numrows'] = $s->rowCount();
		}
		else if (strtolower(substr($query,0,6))=="delete") {
			$s = $db->prepare($query);
			$s->execute();
			$q['numrows'] = $s->rowCount();
		}
		else {
			print $query;
			$s = $db->prepare($query);
			$s->execute();
		}
	//	print $query . "\n\n";
		return $q;
	}

	

	public static function grabNum($v)
	{
		$r = grabVar($v);
		if (!(is_numeric($r))) { $r = 0; }
		return $r;
	}



	public static function grabVar($v)
	{
		$r = "";
		if (isset($_GET[$v])) { $r = $_GET[$v]; }
		if (isset($_POST[$v])) { $r = $_POST[$v]; }
		$ts = "".$r;
		if (str_replace("'","",$ts)!=$ts)
		{
			$r = str_replace("'","&#39;",$r);
		}
		return $r;
	}
		

	public static function grabCurl($url) {
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		$r = curl_exec($curl);
		curl_close($curl);
		return $r;
	}

	
	
	
}

?>