<?php
require_once("../../../php/config.php");
require_once("../../../php/fun.php");
?>


<html>
<head>
	<title>Google Authentication with PHP</title>
	<link rel="stylesheet" type="text/css" href="../../css/main.php" />
	<style type="text/css">
	body {
		font-family: "Century Gothic", sans-serif;
		font-size:1em;
		margin:10px;
	}
	</style>
	
</head>
<body>
	<h2>Google Authentication with PHP</h2>

	<p>
	Here you'll find a very simple Google Authentication feature that you can modify and integrate into your own projects. I'm including the code that I used in two files below, test.php and block.php, so you can see how the code (displayed below each) works with the jetGoogleAuth.php file.
	</p>

    <h3>Instructions</h3>
    
    <p>
    Set up a work space that allows you to run php files in your browser. (If you don't know how to do this, you'll want to <a href="https://www.w3schools.com/php/php_intro.asp">learn that first.</a>)
    </p>
    
	<p>
	<a href="jetGoogleAuth.zip">Download this .zip file.</a>
	</p>


	<p>
	In addition to using this set of files, you'll want to use the <a href="https://developers.google.com/api-client-library/php/" target="_blank">Google API Client (PHP)</a>. Go get set up with a Client ID and Client Secret there and then come back and follow the rest of these instructions. I'm including an empty folder for reference, but you'll want to download and install the latest library from Google, as well as make an adjustment (if necessary) to the path to the autoload in config.php once you're done.
	</p>

    <p>
    Have a look through the test.php and block.php files that are included in the folder as demos. You should be able to view test.php, but be redirected to block.php when you log in. Then, when you log out in block.php, you should be redirected back to test.php. If you try to visit block.php without logging in, you should also be redirected. The code for each is displayed below, and is also included in the zip file.
    </p>
	
	<hr />

	<?php
		$testcode = file_get_contents("test.php");
		$testcode = str_replace("<","&lt;",$testcode);
		$testcode = str_replace(">","&gt;",$testcode);
		$blockcode = file_get_contents("block.php");
		$blockcode = str_replace("<","&lt;",$blockcode);
		$blockcode = str_replace(">","&gt;",$blockcode);
	?>

	<a href="test.php">test.php</a>
	<pre class="code"><?php echo $testcode; ?></pre>
	
	<a href="block.php">block.php</a>
	<pre class="code"><?php echo $blockcode; ?></pre>
	
</body>
</html>
